@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ClusterSecretArchiveArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.ClusterSecretArchiveEnabled
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyVaultId The resource ID of the key vault to archive the secrets of the cluster.
 * @property useKeyVault The indicator if the specified key vault should be used to archive the secrets of the cluster.
 */
public data class ClusterSecretArchiveArgs(
    public val keyVaultId: Output<String>,
    public val useKeyVault: Output<Either<String, ClusterSecretArchiveEnabled>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ClusterSecretArchiveArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.ClusterSecretArchiveArgs =
        com.pulumi.azurenative.networkcloud.inputs.ClusterSecretArchiveArgs.builder()
            .keyVaultId(keyVaultId.applyValue({ args0 -> args0 }))
            .useKeyVault(
                useKeyVault?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterSecretArchiveArgs].
 */
@PulumiTagMarker
public class ClusterSecretArchiveArgsBuilder internal constructor() {
    private var keyVaultId: Output<String>? = null

    private var useKeyVault: Output<Either<String, ClusterSecretArchiveEnabled>>? = null

    /**
     * @param value The resource ID of the key vault to archive the secrets of the cluster.
     */
    @JvmName("fqvqrkdpkfpalxti")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value The indicator if the specified key vault should be used to archive the secrets of the cluster.
     */
    @JvmName("xqljjjdounwxxdix")
    public suspend fun useKeyVault(`value`: Output<Either<String, ClusterSecretArchiveEnabled>>) {
        this.useKeyVault = value
    }

    /**
     * @param value The resource ID of the key vault to archive the secrets of the cluster.
     */
    @JvmName("yjcvgenmfmsrmjdj")
    public suspend fun keyVaultId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value The indicator if the specified key vault should be used to archive the secrets of the cluster.
     */
    @JvmName("rgavdwulgryhpprb")
    public suspend fun useKeyVault(`value`: Either<String, ClusterSecretArchiveEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useKeyVault = mapped
    }

    /**
     * @param value The indicator if the specified key vault should be used to archive the secrets of the cluster.
     */
    @JvmName("mwkcphsgjrowxwco")
    public fun useKeyVault(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterSecretArchiveEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useKeyVault = mapped
    }

    /**
     * @param value The indicator if the specified key vault should be used to archive the secrets of the cluster.
     */
    @JvmName("hlimqbnspshfnxnb")
    public fun useKeyVault(`value`: ClusterSecretArchiveEnabled) {
        val toBeMapped = Either.ofRight<String, ClusterSecretArchiveEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useKeyVault = mapped
    }

    internal fun build(): ClusterSecretArchiveArgs = ClusterSecretArchiveArgs(
        keyVaultId = keyVaultId ?: throw PulumiNullFieldException("keyVaultId"),
        useKeyVault = useKeyVault,
    )
}
