@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ClusterUpdateStrategyArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.ClusterUpdateStrategyType
import com.pulumi.azurenative.networkcloud.kotlin.enums.ValidationThresholdType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxUnavailable The maximum number of worker nodes that can be offline within the increment of update, e.g., rack-by-rack.
 * Limited by the maximum number of machines in the increment. Defaults to the whole increment size.
 * @property strategyType The mode of operation for runtime protection.
 * @property thresholdType Selection of how the threshold should be evaluated.
 * @property thresholdValue The numeric threshold value.
 * @property waitTimeMinutes The time to wait between the increments of update defined by the strategy.
 */
public data class ClusterUpdateStrategyArgs(
    public val maxUnavailable: Output<Double>? = null,
    public val strategyType: Output<Either<String, ClusterUpdateStrategyType>>,
    public val thresholdType: Output<Either<String, ValidationThresholdType>>,
    public val thresholdValue: Output<Double>,
    public val waitTimeMinutes: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ClusterUpdateStrategyArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.ClusterUpdateStrategyArgs =
        com.pulumi.azurenative.networkcloud.inputs.ClusterUpdateStrategyArgs.builder()
            .maxUnavailable(maxUnavailable?.applyValue({ args0 -> args0 }))
            .strategyType(
                strategyType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .thresholdType(
                thresholdType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .thresholdValue(thresholdValue.applyValue({ args0 -> args0 }))
            .waitTimeMinutes(waitTimeMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterUpdateStrategyArgs].
 */
@PulumiTagMarker
public class ClusterUpdateStrategyArgsBuilder internal constructor() {
    private var maxUnavailable: Output<Double>? = null

    private var strategyType: Output<Either<String, ClusterUpdateStrategyType>>? = null

    private var thresholdType: Output<Either<String, ValidationThresholdType>>? = null

    private var thresholdValue: Output<Double>? = null

    private var waitTimeMinutes: Output<Double>? = null

    /**
     * @param value The maximum number of worker nodes that can be offline within the increment of update, e.g., rack-by-rack.
     * Limited by the maximum number of machines in the increment. Defaults to the whole increment size.
     */
    @JvmName("pcpfpvxnnnrkthyi")
    public suspend fun maxUnavailable(`value`: Output<Double>) {
        this.maxUnavailable = value
    }

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("qgmjjkkqtninwala")
    public suspend fun strategyType(`value`: Output<Either<String, ClusterUpdateStrategyType>>) {
        this.strategyType = value
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("qudhdikfivyylwhs")
    public suspend fun thresholdType(`value`: Output<Either<String, ValidationThresholdType>>) {
        this.thresholdType = value
    }

    /**
     * @param value The numeric threshold value.
     */
    @JvmName("sjpngbatboelgpei")
    public suspend fun thresholdValue(`value`: Output<Double>) {
        this.thresholdValue = value
    }

    /**
     * @param value The time to wait between the increments of update defined by the strategy.
     */
    @JvmName("gcfmvstijuqhqjub")
    public suspend fun waitTimeMinutes(`value`: Output<Double>) {
        this.waitTimeMinutes = value
    }

    /**
     * @param value The maximum number of worker nodes that can be offline within the increment of update, e.g., rack-by-rack.
     * Limited by the maximum number of machines in the increment. Defaults to the whole increment size.
     */
    @JvmName("rorneejvywfyyafx")
    public suspend fun maxUnavailable(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnavailable = mapped
    }

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("wxpjhbrdxqntneto")
    public suspend fun strategyType(`value`: Either<String, ClusterUpdateStrategyType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategyType = mapped
    }

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("itykaytudvquwsdo")
    public fun strategyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterUpdateStrategyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategyType = mapped
    }

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("xeeleslnwwostmwk")
    public fun strategyType(`value`: ClusterUpdateStrategyType) {
        val toBeMapped = Either.ofRight<String, ClusterUpdateStrategyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.strategyType = mapped
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("fcyceicxfuvxabnw")
    public suspend fun thresholdType(`value`: Either<String, ValidationThresholdType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("tcqbncjrainqiqij")
    public fun thresholdType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValidationThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("cumnxhxpoerasndd")
    public fun thresholdType(`value`: ValidationThresholdType) {
        val toBeMapped = Either.ofRight<String, ValidationThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value The numeric threshold value.
     */
    @JvmName("yxbjocpgxemfkqia")
    public suspend fun thresholdValue(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdValue = mapped
    }

    /**
     * @param value The time to wait between the increments of update defined by the strategy.
     */
    @JvmName("xywicxigvsycnjym")
    public suspend fun waitTimeMinutes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitTimeMinutes = mapped
    }

    internal fun build(): ClusterUpdateStrategyArgs = ClusterUpdateStrategyArgs(
        maxUnavailable = maxUnavailable,
        strategyType = strategyType ?: throw PulumiNullFieldException("strategyType"),
        thresholdType = thresholdType ?: throw PulumiNullFieldException("thresholdType"),
        thresholdValue = thresholdValue ?: throw PulumiNullFieldException("thresholdValue"),
        waitTimeMinutes = waitTimeMinutes,
    )
}
