@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetKubernetesClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kubernetesClusterName The name of the Kubernetes cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetKubernetesClusterPlainArgs(
    public val kubernetesClusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetKubernetesClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetKubernetesClusterPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetKubernetesClusterPlainArgs.builder()
            .kubernetesClusterName(kubernetesClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKubernetesClusterPlainArgs].
 */
@PulumiTagMarker
public class GetKubernetesClusterPlainArgsBuilder internal constructor() {
    private var kubernetesClusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kubernetes cluster.
     */
    @JvmName("vyxjbcntheqvewym")
    public suspend fun kubernetesClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kubernetesClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gyiceqcvetvjgyui")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetKubernetesClusterPlainArgs = GetKubernetesClusterPlainArgs(
        kubernetesClusterName = kubernetesClusterName ?: throw
            PulumiNullFieldException("kubernetesClusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
