@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetL2NetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property l2NetworkName The name of the L2 network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetL2NetworkPlainArgs(
    public val l2NetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetL2NetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetL2NetworkPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetL2NetworkPlainArgs.builder()
            .l2NetworkName(l2NetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetL2NetworkPlainArgs].
 */
@PulumiTagMarker
public class GetL2NetworkPlainArgsBuilder internal constructor() {
    private var l2NetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the L2 network.
     */
    @JvmName("nvwprihdgnjfmxvr")
    public suspend fun l2NetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.l2NetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pqrlgapxpjehdwmn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetL2NetworkPlainArgs = GetL2NetworkPlainArgs(
        l2NetworkName = l2NetworkName ?: throw PulumiNullFieldException("l2NetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
