@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetMetricsConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster.
 * @property metricsConfigurationName The name of the metrics configuration for the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMetricsConfigurationPlainArgs(
    public val clusterName: String,
    public val metricsConfigurationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetMetricsConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetMetricsConfigurationPlainArgs = com.pulumi.azurenative.networkcloud.inputs.GetMetricsConfigurationPlainArgs.builder()
        .clusterName(clusterName.let({ args0 -> args0 }))
        .metricsConfigurationName(metricsConfigurationName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetricsConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetMetricsConfigurationPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var metricsConfigurationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("blyboqqlpmmdrwow")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the metrics configuration for the cluster.
     */
    @JvmName("uxatcqxbuchqvirj")
    public suspend fun metricsConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metricsConfigurationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmpyvllxjwcecfdy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMetricsConfigurationPlainArgs = GetMetricsConfigurationPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        metricsConfigurationName = metricsConfigurationName ?: throw
            PulumiNullFieldException("metricsConfigurationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
