@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetTrunkedNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property trunkedNetworkName The name of the trunked network.
 */
public data class GetTrunkedNetworkPlainArgs(
    public val resourceGroupName: String,
    public val trunkedNetworkName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetTrunkedNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetTrunkedNetworkPlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetTrunkedNetworkPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .trunkedNetworkName(trunkedNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrunkedNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetTrunkedNetworkPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var trunkedNetworkName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lwelnkdiwvivuiyq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the trunked network.
     */
    @JvmName("fndfiolsutjwnunw")
    public suspend fun trunkedNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trunkedNetworkName = mapped
    }

    internal fun build(): GetTrunkedNetworkPlainArgs = GetTrunkedNetworkPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        trunkedNetworkName = trunkedNetworkName ?: throw PulumiNullFieldException("trunkedNetworkName"),
    )
}
