@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.IpAddressPoolArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.BfdEnabled
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property addresses The list of IP address ranges. Each range can be a either a subnet in CIDR format or an explicit start-end range of IP addresses.
 * @property autoAssign The indicator to determine if automatic allocation from the pool should occur.
 * @property name The name used to identify this IP address pool for association with a BGP advertisement.
 * @property onlyUseHostIps The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only use IP addresses between .1 and .254 inclusive.
 */
public data class IpAddressPoolArgs(
    public val addresses: Output<List<String>>,
    public val autoAssign: Output<Either<String, BfdEnabled>>? = null,
    public val name: Output<String>,
    public val onlyUseHostIps: Output<Either<String, BfdEnabled>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.IpAddressPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.IpAddressPoolArgs =
        com.pulumi.azurenative.networkcloud.inputs.IpAddressPoolArgs.builder()
            .addresses(addresses.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .autoAssign(
                autoAssign?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .onlyUseHostIps(
                onlyUseHostIps?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [IpAddressPoolArgs].
 */
@PulumiTagMarker
public class IpAddressPoolArgsBuilder internal constructor() {
    private var addresses: Output<List<String>>? = null

    private var autoAssign: Output<Either<String, BfdEnabled>>? = null

    private var name: Output<String>? = null

    private var onlyUseHostIps: Output<Either<String, BfdEnabled>>? = null

    /**
     * @param value The list of IP address ranges. Each range can be a either a subnet in CIDR format or an explicit start-end range of IP addresses.
     */
    @JvmName("wcbxtnvwmbpwqlfn")
    public suspend fun addresses(`value`: Output<List<String>>) {
        this.addresses = value
    }

    @JvmName("ardfhobxdbowllsx")
    public suspend fun addresses(vararg values: Output<String>) {
        this.addresses = Output.all(values.asList())
    }

    /**
     * @param values The list of IP address ranges. Each range can be a either a subnet in CIDR format or an explicit start-end range of IP addresses.
     */
    @JvmName("rjestsdvmfvuvnjv")
    public suspend fun addresses(values: List<Output<String>>) {
        this.addresses = Output.all(values)
    }

    /**
     * @param value The indicator to determine if automatic allocation from the pool should occur.
     */
    @JvmName("ttlneyiivuhdqpoj")
    public suspend fun autoAssign(`value`: Output<Either<String, BfdEnabled>>) {
        this.autoAssign = value
    }

    /**
     * @param value The name used to identify this IP address pool for association with a BGP advertisement.
     */
    @JvmName("nabdxbcqmcvruyhf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only use IP addresses between .1 and .254 inclusive.
     */
    @JvmName("mbktcpiivvrxnvxt")
    public suspend fun onlyUseHostIps(`value`: Output<Either<String, BfdEnabled>>) {
        this.onlyUseHostIps = value
    }

    /**
     * @param value The list of IP address ranges. Each range can be a either a subnet in CIDR format or an explicit start-end range of IP addresses.
     */
    @JvmName("mxkchtanqfdaumop")
    public suspend fun addresses(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param values The list of IP address ranges. Each range can be a either a subnet in CIDR format or an explicit start-end range of IP addresses.
     */
    @JvmName("qbsmkqlrlagbbsfo")
    public suspend fun addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param value The indicator to determine if automatic allocation from the pool should occur.
     */
    @JvmName("skyaqkvvyafmfung")
    public suspend fun autoAssign(`value`: Either<String, BfdEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAssign = mapped
    }

    /**
     * @param value The indicator to determine if automatic allocation from the pool should occur.
     */
    @JvmName("bkjuwxovhawbpqgy")
    public fun autoAssign(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BfdEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoAssign = mapped
    }

    /**
     * @param value The indicator to determine if automatic allocation from the pool should occur.
     */
    @JvmName("hnifpdgkrsactpcx")
    public fun autoAssign(`value`: BfdEnabled) {
        val toBeMapped = Either.ofRight<String, BfdEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoAssign = mapped
    }

    /**
     * @param value The name used to identify this IP address pool for association with a BGP advertisement.
     */
    @JvmName("wibmrjvsjobotygg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only use IP addresses between .1 and .254 inclusive.
     */
    @JvmName("fpjabkhltjschymm")
    public suspend fun onlyUseHostIps(`value`: Either<String, BfdEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlyUseHostIps = mapped
    }

    /**
     * @param value The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only use IP addresses between .1 and .254 inclusive.
     */
    @JvmName("qbglpiurxtiqsusp")
    public fun onlyUseHostIps(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BfdEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onlyUseHostIps = mapped
    }

    /**
     * @param value The indicator to prevent the use of IP addresses ending with .0 and .255 for this pool. Enabling this option will only use IP addresses between .1 and .254 inclusive.
     */
    @JvmName("eqdxvkkcyahxavux")
    public fun onlyUseHostIps(`value`: BfdEnabled) {
        val toBeMapped = Either.ofRight<String, BfdEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onlyUseHostIps = mapped
    }

    internal fun build(): IpAddressPoolArgs = IpAddressPoolArgs(
        addresses = addresses ?: throw PulumiNullFieldException("addresses"),
        autoAssign = autoAssign,
        name = name ?: throw PulumiNullFieldException("name"),
        onlyUseHostIps = onlyUseHostIps,
    )
}
