@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.OsDiskArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.OsDiskCreateOption
import com.pulumi.azurenative.networkcloud.kotlin.enums.OsDiskDeleteOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property createOption The strategy for creating the OS disk.
 * @property deleteOption The strategy for deleting the OS disk.
 * @property diskSizeGB The size of the disk in gigabytes. Required if the createOption is Ephemeral.
 */
public data class OsDiskArgs(
    public val createOption: Output<Either<String, OsDiskCreateOption>>? = null,
    public val deleteOption: Output<Either<String, OsDiskDeleteOption>>? = null,
    public val diskSizeGB: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.OsDiskArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.OsDiskArgs =
        com.pulumi.azurenative.networkcloud.inputs.OsDiskArgs.builder()
            .createOption(
                createOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskSizeGB(diskSizeGB.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OsDiskArgs].
 */
@PulumiTagMarker
public class OsDiskArgsBuilder internal constructor() {
    private var createOption: Output<Either<String, OsDiskCreateOption>>? = null

    private var deleteOption: Output<Either<String, OsDiskDeleteOption>>? = null

    private var diskSizeGB: Output<Double>? = null

    /**
     * @param value The strategy for creating the OS disk.
     */
    @JvmName("gyxfsoyfksoonugd")
    public suspend fun createOption(`value`: Output<Either<String, OsDiskCreateOption>>) {
        this.createOption = value
    }

    /**
     * @param value The strategy for deleting the OS disk.
     */
    @JvmName("lpmnjvpvikvgxhnf")
    public suspend fun deleteOption(`value`: Output<Either<String, OsDiskDeleteOption>>) {
        this.deleteOption = value
    }

    /**
     * @param value The size of the disk in gigabytes. Required if the createOption is Ephemeral.
     */
    @JvmName("qpxdkrfoitjevjdc")
    public suspend fun diskSizeGB(`value`: Output<Double>) {
        this.diskSizeGB = value
    }

    /**
     * @param value The strategy for creating the OS disk.
     */
    @JvmName("hcucngudjyueumxp")
    public suspend fun createOption(`value`: Either<String, OsDiskCreateOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value The strategy for creating the OS disk.
     */
    @JvmName("reyubpfviovnsyen")
    public fun createOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsDiskCreateOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value The strategy for creating the OS disk.
     */
    @JvmName("lwfvhkfvukffdocw")
    public fun createOption(`value`: OsDiskCreateOption) {
        val toBeMapped = Either.ofRight<String, OsDiskCreateOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createOption = mapped
    }

    /**
     * @param value The strategy for deleting the OS disk.
     */
    @JvmName("huvmoccrqoqrafrj")
    public suspend fun deleteOption(`value`: Either<String, OsDiskDeleteOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value The strategy for deleting the OS disk.
     */
    @JvmName("lkgsnhlogmnxfihh")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsDiskDeleteOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value The strategy for deleting the OS disk.
     */
    @JvmName("fgnisfxoplqxwsru")
    public fun deleteOption(`value`: OsDiskDeleteOption) {
        val toBeMapped = Either.ofRight<String, OsDiskDeleteOption>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value The size of the disk in gigabytes. Required if the createOption is Ephemeral.
     */
    @JvmName("uwhyvepdskjdatul")
    public suspend fun diskSizeGB(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskSizeGB = mapped
    }

    internal fun build(): OsDiskArgs = OsDiskArgs(
        createOption = createOption,
        deleteOption = deleteOption,
        diskSizeGB = diskSizeGB ?: throw PulumiNullFieldException("diskSizeGB"),
    )
}
