@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.RuntimeProtectionConfigurationArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.RuntimeProtectionEnforcementLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enforcementLevel The mode of operation for runtime protection.
 */
public data class RuntimeProtectionConfigurationArgs(
    public val enforcementLevel: Output<Either<String, RuntimeProtectionEnforcementLevel>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.RuntimeProtectionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.RuntimeProtectionConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.RuntimeProtectionConfigurationArgs.builder()
            .enforcementLevel(
                enforcementLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [RuntimeProtectionConfigurationArgs].
 */
@PulumiTagMarker
public class RuntimeProtectionConfigurationArgsBuilder internal constructor() {
    private var enforcementLevel: Output<Either<String, RuntimeProtectionEnforcementLevel>>? = null

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("knwukittkaeuyidx")
    public suspend fun enforcementLevel(`value`: Output<Either<String, RuntimeProtectionEnforcementLevel>>) {
        this.enforcementLevel = value
    }

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("tyqwuwocatmuveej")
    public suspend fun enforcementLevel(`value`: Either<String, RuntimeProtectionEnforcementLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcementLevel = mapped
    }

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("lnytnlheqkuhfhli")
    public fun enforcementLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuntimeProtectionEnforcementLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforcementLevel = mapped
    }

    /**
     * @param value The mode of operation for runtime protection.
     */
    @JvmName("cqpxnmojxgdjxjig")
    public fun enforcementLevel(`value`: RuntimeProtectionEnforcementLevel) {
        val toBeMapped = Either.ofRight<String, RuntimeProtectionEnforcementLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforcementLevel = mapped
    }

    internal fun build(): RuntimeProtectionConfigurationArgs = RuntimeProtectionConfigurationArgs(
        enforcementLevel = enforcementLevel,
    )
}
