@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.StorageApplianceConfigurationDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property adminCredentials The credentials of the administrative interface on this storage appliance.
 * @property rackSlot The slot that storage appliance is in the rack based on the BOM configuration.
 * @property serialNumber The serial number of the appliance.
 * @property storageApplianceName The user-provided name for the storage appliance that will be created from this specification.
 */
public data class StorageApplianceConfigurationDataArgs(
    public val adminCredentials: Output<AdministrativeCredentialsArgs>,
    public val rackSlot: Output<Double>,
    public val serialNumber: Output<String>,
    public val storageApplianceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.StorageApplianceConfigurationDataArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.StorageApplianceConfigurationDataArgs =
        com.pulumi.azurenative.networkcloud.inputs.StorageApplianceConfigurationDataArgs.builder()
            .adminCredentials(adminCredentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rackSlot(rackSlot.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber.applyValue({ args0 -> args0 }))
            .storageApplianceName(storageApplianceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageApplianceConfigurationDataArgs].
 */
@PulumiTagMarker
public class StorageApplianceConfigurationDataArgsBuilder internal constructor() {
    private var adminCredentials: Output<AdministrativeCredentialsArgs>? = null

    private var rackSlot: Output<Double>? = null

    private var serialNumber: Output<String>? = null

    private var storageApplianceName: Output<String>? = null

    /**
     * @param value The credentials of the administrative interface on this storage appliance.
     */
    @JvmName("yunofjjenrfmejbg")
    public suspend fun adminCredentials(`value`: Output<AdministrativeCredentialsArgs>) {
        this.adminCredentials = value
    }

    /**
     * @param value The slot that storage appliance is in the rack based on the BOM configuration.
     */
    @JvmName("sfmiofauygucljlb")
    public suspend fun rackSlot(`value`: Output<Double>) {
        this.rackSlot = value
    }

    /**
     * @param value The serial number of the appliance.
     */
    @JvmName("htvnwbugpcglcnqa")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value The user-provided name for the storage appliance that will be created from this specification.
     */
    @JvmName("ovhgvndorxxnllcd")
    public suspend fun storageApplianceName(`value`: Output<String>) {
        this.storageApplianceName = value
    }

    /**
     * @param value The credentials of the administrative interface on this storage appliance.
     */
    @JvmName("usvsqpjeodxiuivl")
    public suspend fun adminCredentials(`value`: AdministrativeCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminCredentials = mapped
    }

    /**
     * @param argument The credentials of the administrative interface on this storage appliance.
     */
    @JvmName("irsrvsklkbjwbbkm")
    public suspend fun adminCredentials(argument: suspend AdministrativeCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = AdministrativeCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adminCredentials = mapped
    }

    /**
     * @param value The slot that storage appliance is in the rack based on the BOM configuration.
     */
    @JvmName("idqwiqyuonmdjhsw")
    public suspend fun rackSlot(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rackSlot = mapped
    }

    /**
     * @param value The serial number of the appliance.
     */
    @JvmName("wkodtfnybrerdajs")
    public suspend fun serialNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value The user-provided name for the storage appliance that will be created from this specification.
     */
    @JvmName("xhcteahlqakgpuvx")
    public suspend fun storageApplianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageApplianceName = mapped
    }

    internal fun build(): StorageApplianceConfigurationDataArgs =
        StorageApplianceConfigurationDataArgs(
            adminCredentials = adminCredentials ?: throw PulumiNullFieldException("adminCredentials"),
            rackSlot = rackSlot ?: throw PulumiNullFieldException("rackSlot"),
            serialNumber = serialNumber ?: throw PulumiNullFieldException("serialNumber"),
            storageApplianceName = storageApplianceName,
        )
}
