@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ValidationThresholdArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.ValidationThresholdGrouping
import com.pulumi.azurenative.networkcloud.kotlin.enums.ValidationThresholdType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property grouping Selection of how the type evaluation is applied to the cluster calculation.
 * @property type Selection of how the threshold should be evaluated.
 * @property value The numeric threshold value.
 */
public data class ValidationThresholdArgs(
    public val grouping: Output<Either<String, ValidationThresholdGrouping>>,
    public val type: Output<Either<String, ValidationThresholdType>>,
    public val `value`: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ValidationThresholdArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.ValidationThresholdArgs =
        com.pulumi.azurenative.networkcloud.inputs.ValidationThresholdArgs.builder()
            .grouping(
                grouping.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ValidationThresholdArgs].
 */
@PulumiTagMarker
public class ValidationThresholdArgsBuilder internal constructor() {
    private var grouping: Output<Either<String, ValidationThresholdGrouping>>? = null

    private var type: Output<Either<String, ValidationThresholdType>>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value Selection of how the type evaluation is applied to the cluster calculation.
     */
    @JvmName("fiscgvjmxvdycdwl")
    public suspend fun grouping(`value`: Output<Either<String, ValidationThresholdGrouping>>) {
        this.grouping = value
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("ucullcrkjmaeafub")
    public suspend fun type(`value`: Output<Either<String, ValidationThresholdType>>) {
        this.type = value
    }

    /**
     * @param value The numeric threshold value.
     */
    @JvmName("eidrrewabjgnrsdx")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value Selection of how the type evaluation is applied to the cluster calculation.
     */
    @JvmName("kwfqglfhuwoqyvxd")
    public suspend fun grouping(`value`: Either<String, ValidationThresholdGrouping>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    /**
     * @param value Selection of how the type evaluation is applied to the cluster calculation.
     */
    @JvmName("ocutpxussiissrgo")
    public fun grouping(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValidationThresholdGrouping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    /**
     * @param value Selection of how the type evaluation is applied to the cluster calculation.
     */
    @JvmName("mxynirvfwuyjvaoj")
    public fun grouping(`value`: ValidationThresholdGrouping) {
        val toBeMapped = Either.ofRight<String, ValidationThresholdGrouping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("wlssgyqjmvfvoisc")
    public suspend fun type(`value`: Either<String, ValidationThresholdType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("fvbbpkdqlegbeiyn")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ValidationThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Selection of how the threshold should be evaluated.
     */
    @JvmName("cvwaxdyowsngohgg")
    public fun type(`value`: ValidationThresholdType) {
        val toBeMapped = Either.ofRight<String, ValidationThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The numeric threshold value.
     */
    @JvmName("jobvirgkdbcwxhff")
    public suspend fun `value`(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ValidationThresholdArgs = ValidationThresholdArgs(
        grouping = grouping ?: throw PulumiNullFieldException("grouping"),
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
