@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property adminUsername The user name for the administrator that will be applied to the operating systems that run Kubernetes nodes. If not supplied, a user name will be chosen by the service.
 * @property sshPublicKeys The SSH configuration for the operating systems that run the nodes in the Kubernetes cluster. In some cases, specification of public keys may be required to produce a working environment.
 */
public data class AdministratorConfigurationResponse(
    public val adminUsername: String? = null,
    public val sshPublicKeys: List<SshPublicKeyResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.AdministratorConfigurationResponse): AdministratorConfigurationResponse = AdministratorConfigurationResponse(
            adminUsername = javaType.adminUsername().map({ args0 -> args0 }).orElse(null),
            sshPublicKeys = javaType.sshPublicKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
