@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hugepagesCount The number of hugepages to allocate.
 * @property hugepagesSize The size of the hugepages to allocate.
 */
public data class AgentOptionsResponse(
    public val hugepagesCount: Double,
    public val hugepagesSize: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.AgentOptionsResponse): AgentOptionsResponse = AgentOptionsResponse(
            hugepagesCount = javaType.hugepagesCount(),
            hugepagesSize = javaType.hugepagesSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
