@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bmcConnectionString The connection string for the baseboard management controller including IP address and protocol.
 * @property bmcCredentials The credentials of the baseboard management controller on this bare metal machine.
 * @property bmcMacAddress The MAC address of the BMC for this machine.
 * @property bootMacAddress The MAC address associated with the PXE NIC card.
 * @property machineDetails The free-form additional information about the machine, e.g. an asset tag.
 * @property machineName The user-provided name for the bare metal machine created from this specification.
 * If not provided, the machine name will be generated programmatically.
 * @property rackSlot The slot the physical machine is in the rack based on the BOM configuration.
 * @property serialNumber The serial number of the machine. Hardware suppliers may use an alternate value. For example, service tag.
 */
public data class BareMetalMachineConfigurationDataResponse(
    public val bmcConnectionString: String,
    public val bmcCredentials: AdministrativeCredentialsResponse,
    public val bmcMacAddress: String,
    public val bootMacAddress: String,
    public val machineDetails: String? = null,
    public val machineName: String? = null,
    public val rackSlot: Double,
    public val serialNumber: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.BareMetalMachineConfigurationDataResponse): BareMetalMachineConfigurationDataResponse = BareMetalMachineConfigurationDataResponse(
            bmcConnectionString = javaType.bmcConnectionString(),
            bmcCredentials = javaType.bmcCredentials().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse.Companion.toKotlin(args0)
            }),
            bmcMacAddress = javaType.bmcMacAddress(),
            bootMacAddress = javaType.bootMacAddress(),
            machineDetails = javaType.machineDetails().map({ args0 -> args0 }).orElse(null),
            machineName = javaType.machineName().map({ args0 -> args0 }).orElse(null),
            rackSlot = javaType.rackSlot(),
            serialNumber = javaType.serialNumber(),
        )
    }
}
