@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bgpAdvertisements The association of IP address pools to the communities and peers, allowing for announcement of IPs.
 * @property bgpPeers The list of additional BgpPeer entities that the Kubernetes cluster will peer with. All peering must be explicitly defined.
 * @property fabricPeeringEnabled The indicator to specify if the load balancer peers with the network fabric.
 * @property ipAddressPools The list of pools of IP addresses that can be allocated to Load Balancer services.
 */
public data class BgpServiceLoadBalancerConfigurationResponse(
    public val bgpAdvertisements: List<BgpAdvertisementResponse>? = null,
    public val bgpPeers: List<ServiceLoadBalancerBgpPeerResponse>? = null,
    public val fabricPeeringEnabled: String? = null,
    public val ipAddressPools: List<IpAddressPoolResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.BgpServiceLoadBalancerConfigurationResponse): BgpServiceLoadBalancerConfigurationResponse = BgpServiceLoadBalancerConfigurationResponse(
            bgpAdvertisements = javaType.bgpAdvertisements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.BgpAdvertisementResponse.Companion.toKotlin(args0)
                })
            }),
            bgpPeers = javaType.bgpPeers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ServiceLoadBalancerBgpPeerResponse.Companion.toKotlin(args0)
                })
            }),
            fabricPeeringEnabled = javaType.fabricPeeringEnabled().map({ args0 -> args0 }).orElse(null),
            ipAddressPools = javaType.ipAddressPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.IpAddressPoolResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
