@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property supportExpiryDate The last date the version of the platform is supported.
 * @property targetClusterVersion The version of the cluster to be deployed.
 */
public data class ClusterAvailableVersionResponse(
    public val supportExpiryDate: String,
    public val targetClusterVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ClusterAvailableVersionResponse): ClusterAvailableVersionResponse = ClusterAvailableVersionResponse(
            supportExpiryDate = javaType.supportExpiryDate(),
            targetClusterVersion = javaType.targetClusterVersion(),
        )
    }
}
