@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property availableApplianceStorageGB The remaining appliance-based storage in GB available for workload use.
 * @property availableCoreCount The remaining number of cores that are available in this cluster for workload use.
 * @property availableHostStorageGB The remaining machine or host-based storage in GB available for workload use.
 * @property availableMemoryGB The remaining memory in GB that are available in this cluster for workload use.
 * @property totalApplianceStorageGB The total appliance-based storage in GB supported by this cluster for workload use.
 * @property totalCoreCount The total number of cores that are supported by this cluster for workload use.
 * @property totalHostStorageGB The total machine or host-based storage in GB supported by this cluster for workload use.
 * @property totalMemoryGB The total memory supported by this cluster for workload use.
 */
public data class ClusterCapacityResponse(
    public val availableApplianceStorageGB: Double? = null,
    public val availableCoreCount: Double? = null,
    public val availableHostStorageGB: Double? = null,
    public val availableMemoryGB: Double? = null,
    public val totalApplianceStorageGB: Double? = null,
    public val totalCoreCount: Double? = null,
    public val totalHostStorageGB: Double? = null,
    public val totalMemoryGB: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ClusterCapacityResponse): ClusterCapacityResponse = ClusterCapacityResponse(
            availableApplianceStorageGB = javaType.availableApplianceStorageGB().map({ args0 ->
                args0
            }).orElse(null),
            availableCoreCount = javaType.availableCoreCount().map({ args0 -> args0 }).orElse(null),
            availableHostStorageGB = javaType.availableHostStorageGB().map({ args0 -> args0 }).orElse(null),
            availableMemoryGB = javaType.availableMemoryGB().map({ args0 -> args0 }).orElse(null),
            totalApplianceStorageGB = javaType.totalApplianceStorageGB().map({ args0 -> args0 }).orElse(null),
            totalCoreCount = javaType.totalCoreCount().map({ args0 -> args0 }).orElse(null),
            totalHostStorageGB = javaType.totalHostStorageGB().map({ args0 -> args0 }).orElse(null),
            totalMemoryGB = javaType.totalMemoryGB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
