@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyVaultId The resource ID of the key vault to archive the secrets of the cluster.
 * @property useKeyVault The indicator if the specified key vault should be used to archive the secrets of the cluster.
 */
public data class ClusterSecretArchiveResponse(
    public val keyVaultId: String,
    public val useKeyVault: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ClusterSecretArchiveResponse): ClusterSecretArchiveResponse = ClusterSecretArchiveResponse(
            keyVaultId = javaType.keyVaultId(),
            useKeyVault = javaType.useKeyVault().map({ args0 -> args0 }).orElse(null),
        )
    }
}
