@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maxUnavailable The maximum number of worker nodes that can be offline within the increment of update, e.g., rack-by-rack.
 * Limited by the maximum number of machines in the increment. Defaults to the whole increment size.
 * @property strategyType The mode of operation for runtime protection.
 * @property thresholdType Selection of how the threshold should be evaluated.
 * @property thresholdValue The numeric threshold value.
 * @property waitTimeMinutes The time to wait between the increments of update defined by the strategy.
 */
public data class ClusterUpdateStrategyResponse(
    public val maxUnavailable: Double? = null,
    public val strategyType: String,
    public val thresholdType: String,
    public val thresholdValue: Double,
    public val waitTimeMinutes: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ClusterUpdateStrategyResponse): ClusterUpdateStrategyResponse = ClusterUpdateStrategyResponse(
            maxUnavailable = javaType.maxUnavailable().map({ args0 -> args0 }).orElse(null),
            strategyType = javaType.strategyType(),
            thresholdType = javaType.thresholdType(),
            thresholdValue = javaType.thresholdValue(),
            waitTimeMinutes = javaType.waitTimeMinutes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
