@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property administratorConfiguration The administrator credentials to be used for the nodes in the control plane.
 * @property availabilityZones The list of availability zones of the Network Cloud cluster to be used for the provisioning of nodes in the control plane. If not specified, all availability zones will be used.
 * @property count The number of virtual machines that use this configuration.
 * @property vmSkuName The name of the VM SKU supplied during creation.
 */
public data class ControlPlaneNodeConfigurationResponse(
    public val administratorConfiguration: AdministratorConfigurationResponse? = null,
    public val availabilityZones: List<String>? = null,
    public val count: Double,
    public val vmSkuName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ControlPlaneNodeConfigurationResponse): ControlPlaneNodeConfigurationResponse = ControlPlaneNodeConfigurationResponse(
            administratorConfiguration = javaType.administratorConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            count = javaType.count(),
            vmSkuName = javaType.vmSkuName(),
        )
    }
}
