@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property category The descriptive category name of endpoints accessible by the AKS agent node. For example, azure-resource-management, API server, etc. The platform egress endpoints provided by default will use the category 'default'.
 * @property endpoints The list of endpoint dependencies.
 */
public data class EgressEndpointResponse(
    public val category: String,
    public val endpoints: List<EndpointDependencyResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.EgressEndpointResponse): EgressEndpointResponse = EgressEndpointResponse(
            category = javaType.category(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.EndpointDependencyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
