@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The resource ID of the extended location on which the resource will be created.
 * @property type The extended location type, for example, CustomLocation.
 */
public data class ExtendedLocationResponse(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ExtendedLocationResponse): ExtendedLocationResponse = ExtendedLocationResponse(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
