@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property detailedStatus The status representing the state of this feature.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property name The name of the feature.
 * @property version The version of the feature.
 */
public data class FeatureStatusResponse(
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.FeatureStatusResponse): FeatureStatusResponse = FeatureStatusResponse(
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
