@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property administratorConfiguration The administrator credentials to be used for the nodes in this agent pool.
 * @property agentOptions The configurations that will be applied to each agent in this agent pool.
 * @property attachedNetworkConfiguration The configuration of networks being attached to the agent pool for use by the workloads that run on this Kubernetes cluster.
 * @property availabilityZones The list of availability zones of the Network Cloud cluster used for the provisioning of nodes in this agent pool. If not specified, all availability zones will be used.
 * @property count The number of virtual machines that use this configuration.
 * @property detailedStatus The current status of the agent pool.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property kubernetesVersion The Kubernetes version running in this agent pool.
 * @property labels The labels applied to the nodes in this agent pool.
 * @property location The geo-location where the resource lives
 * @property mode The selection of how this agent pool is utilized, either as a system pool or a user pool. System pools run the features and critical services for the Kubernetes Cluster, while user pools are dedicated to user workloads. Every Kubernetes cluster must contain at least one system node pool with at least one node.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the agent pool.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property taints The taints applied to the nodes in this agent pool.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property upgradeSettings The configuration of the agent pool.
 * @property vmSkuName The name of the VM SKU that determines the size of resources allocated for node VMs.
 */
public data class GetAgentPoolResult(
    public val administratorConfiguration: AdministratorConfigurationResponse? = null,
    public val agentOptions: AgentOptionsResponse? = null,
    public val attachedNetworkConfiguration: AttachedNetworkConfigurationResponse? = null,
    public val availabilityZones: List<String>? = null,
    public val count: Double,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val kubernetesVersion: String,
    public val labels: List<KubernetesLabelResponse>? = null,
    public val location: String,
    public val mode: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val taints: List<KubernetesLabelResponse>? = null,
    public val type: String,
    public val upgradeSettings: AgentPoolUpgradeSettingsResponse? = null,
    public val vmSkuName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetAgentPoolResult): GetAgentPoolResult = GetAgentPoolResult(
            administratorConfiguration = javaType.administratorConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentOptions = javaType.agentOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            attachedNetworkConfiguration = javaType.attachedNetworkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AttachedNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            count = javaType.count(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            kubernetesVersion = javaType.kubernetesVersion(),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            mode = javaType.mode(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taints = javaType.taints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesLabelResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            upgradeSettings = javaType.upgradeSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AgentPoolUpgradeSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vmSkuName = javaType.vmSkuName(),
        )
    }
}
