@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property associatedResourceIds The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
 * @property bmcConnectionString The connection string for the baseboard management controller including IP address and protocol.
 * @property bmcCredentials The credentials of the baseboard management controller on this bare metal machine.
 * @property bmcMacAddress The MAC address of the BMC device.
 * @property bootMacAddress The MAC address of a NIC connected to the PXE network.
 * @property clusterId The resource ID of the cluster this bare metal machine is associated with.
 * @property cordonStatus The cordon status of the bare metal machine.
 * @property detailedStatus The more detailed status of the bare metal machine.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hardwareInventory The hardware inventory, including information acquired from the model/sku information and from the ironic inspector.
 * @property hardwareValidationStatus The details of the latest hardware validation performed for this bare metal machine.
 * @property hybridAksClustersAssociatedIds Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the HybridAksClusters that have nodes hosted on this bare metal machine.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property kubernetesNodeName The name of this machine represented by the host object in the Cluster's Kubernetes control plane.
 * @property kubernetesVersion The version of Kubernetes running on this machine.
 * @property location The geo-location where the resource lives
 * @property machineDetails The custom details provided by the customer.
 * @property machineName The OS-level hostname assigned to this machine.
 * @property machineRoles The list of roles that are assigned to the cluster node running on this machine.
 * @property machineSkuId The unique internal identifier of the bare metal machine SKU.
 * @property name The name of the resource
 * @property oamIpv4Address The IPv4 address that is assigned to the bare metal machine during the cluster deployment.
 * @property oamIpv6Address The IPv6 address that is assigned to the bare metal machine during the cluster deployment.
 * @property osImage The image that is currently provisioned to the OS disk.
 * @property powerState The power state derived from the baseboard management controller.
 * @property provisioningState The provisioning state of the bare metal machine.
 * @property rackId The resource ID of the rack where this bare metal machine resides.
 * @property rackSlot The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1.
 * @property readyState The indicator of whether the bare metal machine is ready to receive workloads.
 * @property runtimeProtectionStatus The runtime protection status of the bare metal machine.
 * @property serialNumber The serial number of the bare metal machine.
 * @property serviceTag The discovered value of the machine's service tag.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualMachinesAssociatedIds Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the VirtualMachines that are hosted on this bare metal machine.
 */
public data class GetBareMetalMachineResult(
    public val associatedResourceIds: List<String>,
    public val bmcConnectionString: String,
    public val bmcCredentials: AdministrativeCredentialsResponse,
    public val bmcMacAddress: String,
    public val bootMacAddress: String,
    public val clusterId: String,
    public val cordonStatus: String,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val hardwareInventory: HardwareInventoryResponse,
    public val hardwareValidationStatus: HardwareValidationStatusResponse,
    public val hybridAksClustersAssociatedIds: List<String>,
    public val id: String,
    public val kubernetesNodeName: String,
    public val kubernetesVersion: String,
    public val location: String,
    public val machineDetails: String,
    public val machineName: String,
    public val machineRoles: List<String>,
    public val machineSkuId: String,
    public val name: String,
    public val oamIpv4Address: String,
    public val oamIpv6Address: String,
    public val osImage: String,
    public val powerState: String,
    public val provisioningState: String,
    public val rackId: String,
    public val rackSlot: Double,
    public val readyState: String,
    public val runtimeProtectionStatus: RuntimeProtectionStatusResponse,
    public val serialNumber: String,
    public val serviceTag: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachinesAssociatedIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetBareMetalMachineResult): GetBareMetalMachineResult = GetBareMetalMachineResult(
            associatedResourceIds = javaType.associatedResourceIds().map({ args0 -> args0 }),
            bmcConnectionString = javaType.bmcConnectionString(),
            bmcCredentials = javaType.bmcCredentials().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse.Companion.toKotlin(args0)
            }),
            bmcMacAddress = javaType.bmcMacAddress(),
            bootMacAddress = javaType.bootMacAddress(),
            clusterId = javaType.clusterId(),
            cordonStatus = javaType.cordonStatus(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            hardwareInventory = javaType.hardwareInventory().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.HardwareInventoryResponse.Companion.toKotlin(args0)
            }),
            hardwareValidationStatus = javaType.hardwareValidationStatus().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.HardwareValidationStatusResponse.Companion.toKotlin(args0)
            }),
            hybridAksClustersAssociatedIds = javaType.hybridAksClustersAssociatedIds().map({ args0 -> args0 }),
            id = javaType.id(),
            kubernetesNodeName = javaType.kubernetesNodeName(),
            kubernetesVersion = javaType.kubernetesVersion(),
            location = javaType.location(),
            machineDetails = javaType.machineDetails(),
            machineName = javaType.machineName(),
            machineRoles = javaType.machineRoles().map({ args0 -> args0 }),
            machineSkuId = javaType.machineSkuId(),
            name = javaType.name(),
            oamIpv4Address = javaType.oamIpv4Address(),
            oamIpv6Address = javaType.oamIpv6Address(),
            osImage = javaType.osImage(),
            powerState = javaType.powerState(),
            provisioningState = javaType.provisioningState(),
            rackId = javaType.rackId(),
            rackSlot = javaType.rackSlot(),
            readyState = javaType.readyState(),
            runtimeProtectionStatus = javaType.runtimeProtectionStatus().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.RuntimeProtectionStatusResponse.Companion.toKotlin(args0)
            }),
            serialNumber = javaType.serialNumber(),
            serviceTag = javaType.serviceTag(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachinesAssociatedIds = javaType.virtualMachinesAssociatedIds().map({ args0 -> args0 }),
        )
    }
}
