@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property azureGroupId The object ID of Azure Active Directory group that all users in the list must be in for access to be granted. Users that are not in the group will not have access.
 * @property detailedStatus The more detailed status of the key set.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property expiration The date and time after which the users in this key set will be removed from the baseboard management controllers.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property lastValidation The last time this key set was validated.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privilegeLevel The access level allowed for the users in this key set.
 * @property provisioningState The provisioning state of the baseboard management controller key set.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userList The unique list of permitted users.
 * @property userListStatus The status evaluation of each user.
 */
public data class GetBmcKeySetResult(
    public val azureGroupId: String,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val expiration: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val lastValidation: String,
    public val location: String,
    public val name: String,
    public val privilegeLevel: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userList: List<KeySetUserResponse>,
    public val userListStatus: List<KeySetUserStatusResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetBmcKeySetResult): GetBmcKeySetResult = GetBmcKeySetResult(
            azureGroupId = javaType.azureGroupId(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            expiration = javaType.expiration(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            lastValidation = javaType.lastValidation(),
            location = javaType.location(),
            name = javaType.name(),
            privilegeLevel = javaType.privilegeLevel(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userList = javaType.userList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserResponse.Companion.toKotlin(args0)
                })
            }),
            userListStatus = javaType.userListStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KeySetUserStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
