@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Upon creation, the additional services that are provided by the platform will be allocated and
 * represented in the status of this resource. All resources associated with this cloud services network will be part
 * of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused across many
 * virtual machines and/or Hybrid AKS clusters.
 * @property additionalEgressEndpoints The list of egress endpoints. This allows for connection from a Hybrid AKS cluster to the specified endpoint.
 * @property associatedResourceIds The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
 * @property clusterId The resource ID of the Network Cloud cluster this cloud services network is associated with.
 * @property detailedStatus The more detailed status of the cloud services network.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property enableDefaultEgressEndpoints The indicator of whether the platform default endpoints are allowed for the egress traffic.
 * @property enabledEgressEndpoints The full list of additional and default egress endpoints that are currently enabled.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hybridAksClustersAssociatedIds Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated with this cloud services network.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property interfaceName The name of the interface that will be present in the virtual machine to represent this network.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the cloud services network.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualMachinesAssociatedIds Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this cloud services network.
 */
public data class GetCloudServicesNetworkResult(
    public val additionalEgressEndpoints: List<EgressEndpointResponse>? = null,
    public val associatedResourceIds: List<String>,
    public val clusterId: String,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val enableDefaultEgressEndpoints: String? = null,
    public val enabledEgressEndpoints: List<EgressEndpointResponse>,
    public val extendedLocation: ExtendedLocationResponse,
    public val hybridAksClustersAssociatedIds: List<String>,
    public val id: String,
    public val interfaceName: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachinesAssociatedIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetCloudServicesNetworkResult): GetCloudServicesNetworkResult = GetCloudServicesNetworkResult(
            additionalEgressEndpoints = javaType.additionalEgressEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.EgressEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            associatedResourceIds = javaType.associatedResourceIds().map({ args0 -> args0 }),
            clusterId = javaType.clusterId(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            enableDefaultEgressEndpoints = javaType.enableDefaultEgressEndpoints().map({ args0 ->
                args0
            }).orElse(null),
            enabledEgressEndpoints = javaType.enabledEgressEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.EgressEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            hybridAksClustersAssociatedIds = javaType.hybridAksClustersAssociatedIds().map({ args0 -> args0 }),
            id = javaType.id(),
            interfaceName = javaType.interfaceName(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachinesAssociatedIds = javaType.virtualMachinesAssociatedIds().map({ args0 -> args0 }),
        )
    }
}
