@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property detailedStatus The more detailed status of the console.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property enabled The indicator of whether the console access is enabled.
 * @property expiration The date and time after which the key will be disallowed access.
 * @property extendedLocation The extended location of the cluster manager associated with the cluster this virtual machine is created on.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateLinkServiceId The resource ID of the private link service that is used to provide virtual machine console access.
 * @property provisioningState The provisioning state of the virtual machine console.
 * @property sshPublicKey The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualMachineAccessId The unique identifier for the virtual machine that is used to access the console.
 */
public data class GetConsoleResult(
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val enabled: String,
    public val expiration: String? = null,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateLinkServiceId: String,
    public val provisioningState: String,
    public val sshPublicKey: SshPublicKeyResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualMachineAccessId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetConsoleResult): GetConsoleResult = GetConsoleResult(
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            enabled = javaType.enabled(),
            expiration = javaType.expiration().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateLinkServiceId = javaType.privateLinkServiceId(),
            provisioningState = javaType.provisioningState(),
            sshPublicKey = javaType.sshPublicKey().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualMachineAccessId = javaType.virtualMachineAccessId(),
        )
    }
}
