@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property aadConfiguration The Azure Active Directory Integration properties.
 * @property administratorConfiguration The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
 * @property attachedNetworkIds The full list of network resource IDs that are attached to this cluster, including those attached only to specific agent pools.
 * @property availableUpgrades The list of versions that this Kubernetes cluster can be upgraded to.
 * @property clusterId The resource ID of the Network Cloud cluster.
 * @property connectedClusterId The resource ID of the connected cluster set up when this Kubernetes cluster is created.
 * @property controlPlaneKubernetesVersion The current running version of Kubernetes on the control plane.
 * @property controlPlaneNodeConfiguration The defining characteristics of the control plane for this Kubernetes Cluster.
 * @property detailedStatus The current status of the Kubernetes cluster.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property featureStatuses The current feature settings.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property initialAgentPoolConfigurations The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
 * @property kubernetesVersion The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration The configuration of the managed resource group associated with the resource.
 * @property name The name of the resource
 * @property networkConfiguration The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
 * @property nodes The details of the nodes in this cluster.
 * @property provisioningState The provisioning state of the Kubernetes cluster resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetKubernetesClusterResult(
    public val aadConfiguration: AadConfigurationResponse? = null,
    public val administratorConfiguration: AdministratorConfigurationResponse? = null,
    public val attachedNetworkIds: List<String>,
    public val availableUpgrades: List<AvailableUpgradeResponse>,
    public val clusterId: String,
    public val connectedClusterId: String,
    public val controlPlaneKubernetesVersion: String,
    public val controlPlaneNodeConfiguration: ControlPlaneNodeConfigurationResponse,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val featureStatuses: List<FeatureStatusResponse>,
    public val id: String,
    public val initialAgentPoolConfigurations: List<InitialAgentPoolConfigurationResponse>,
    public val kubernetesVersion: String,
    public val location: String,
    public val managedResourceGroupConfiguration: ManagedResourceGroupConfigurationResponse? = null,
    public val name: String,
    public val networkConfiguration: NetworkConfigurationResponse,
    public val nodes: List<KubernetesClusterNodeResponse>,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetKubernetesClusterResult): GetKubernetesClusterResult = GetKubernetesClusterResult(
            aadConfiguration = javaType.aadConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AadConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            administratorConfiguration = javaType.administratorConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            attachedNetworkIds = javaType.attachedNetworkIds().map({ args0 -> args0 }),
            availableUpgrades = javaType.availableUpgrades().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AvailableUpgradeResponse.Companion.toKotlin(args0)
                })
            }),
            clusterId = javaType.clusterId(),
            connectedClusterId = javaType.connectedClusterId(),
            controlPlaneKubernetesVersion = javaType.controlPlaneKubernetesVersion(),
            controlPlaneNodeConfiguration = javaType.controlPlaneNodeConfiguration().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ControlPlaneNodeConfigurationResponse.Companion.toKotlin(args0)
            }),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            featureStatuses = javaType.featureStatuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.FeatureStatusResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            initialAgentPoolConfigurations = javaType.initialAgentPoolConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.InitialAgentPoolConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            kubernetesVersion = javaType.kubernetesVersion(),
            location = javaType.location(),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkConfiguration = javaType.networkConfiguration().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkConfigurationResponse.Companion.toKotlin(args0)
            }),
            nodes = javaType.nodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesClusterNodeResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
