@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property collectionInterval The interval in minutes by which metrics will be collected.
 * @property detailedStatus The more detailed status of the metrics configuration.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property disabledMetrics The list of metrics that are available for the cluster but disabled at the moment.
 * @property enabledMetrics The list of metric names that have been chosen to be enabled in addition to the core set of enabled metrics.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the metrics configuration.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMetricsConfigurationResult(
    public val collectionInterval: Double,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val disabledMetrics: List<String>,
    public val enabledMetrics: List<String>? = null,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetMetricsConfigurationResult): GetMetricsConfigurationResult = GetMetricsConfigurationResult(
            collectionInterval = javaType.collectionInterval(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            disabledMetrics = javaType.disabledMetrics().map({ args0 -> args0 }),
            enabledMetrics = javaType.enabledMetrics().map({ args0 -> args0 }),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
