@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property availabilityZone The value that will be used for machines in this rack to represent the availability zones that can be referenced by Hybrid AKS Clusters for node arrangement.
 * @property clusterId The resource ID of the cluster the rack is created for. This value is set when the rack is created by the cluster.
 * @property detailedStatus The more detailed status of the rack.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the rack resource.
 * @property rackLocation The free-form description of the rack location. (e.g. “DTN Datacenter, Floor 3, Isle 9, Rack 2B”)
 * @property rackSerialNumber The unique identifier for the rack within Network Cloud cluster. An alternate unique alphanumeric value other than a serial number may be provided if desired.
 * @property rackSkuId The SKU for the rack.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetRackResult(
    public val availabilityZone: String,
    public val clusterId: String,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val rackLocation: String,
    public val rackSerialNumber: String,
    public val rackSkuId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetRackResult): GetRackResult = GetRackResult(
            availabilityZone = javaType.availabilityZone(),
            clusterId = javaType.clusterId(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            rackLocation = javaType.rackLocation(),
            rackSerialNumber = javaType.rackSerialNumber(),
            rackSkuId = javaType.rackSkuId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
