@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property administratorCredentials The credentials of the administrative interface on this storage appliance.
 * @property capacity The total capacity of the storage appliance.
 * @property capacityUsed The amount of storage consumed.
 * @property clusterId The resource ID of the cluster this storage appliance is associated with.
 * @property detailedStatus The detailed status of the storage appliance.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property managementIpv4Address The endpoint for the management interface of the storage appliance.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the storage appliance.
 * @property rackId The resource ID of the rack where this storage appliance resides.
 * @property rackSlot The slot the storage appliance is in the rack based on the BOM configuration.
 * @property remoteVendorManagementFeature The indicator of whether the storage appliance supports remote vendor management.
 * @property remoteVendorManagementStatus The indicator of whether the remote vendor management feature is enabled or disabled, or unsupported if it is an unsupported feature.
 * @property serialNumber The serial number for the storage appliance.
 * @property storageApplianceSkuId The SKU for the storage appliance.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStorageApplianceResult(
    public val administratorCredentials: AdministrativeCredentialsResponse,
    public val capacity: Double,
    public val capacityUsed: Double,
    public val clusterId: String,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val location: String,
    public val managementIpv4Address: String,
    public val name: String,
    public val provisioningState: String,
    public val rackId: String,
    public val rackSlot: Double,
    public val remoteVendorManagementFeature: String,
    public val remoteVendorManagementStatus: String,
    public val serialNumber: String,
    public val storageApplianceSkuId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetStorageApplianceResult): GetStorageApplianceResult = GetStorageApplianceResult(
            administratorCredentials = javaType.administratorCredentials().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministrativeCredentialsResponse.Companion.toKotlin(args0)
            }),
            capacity = javaType.capacity(),
            capacityUsed = javaType.capacityUsed(),
            clusterId = javaType.clusterId(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            managementIpv4Address = javaType.managementIpv4Address(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            rackId = javaType.rackId(),
            rackSlot = javaType.rackSlot(),
            remoteVendorManagementFeature = javaType.remoteVendorManagementFeature(),
            remoteVendorManagementStatus = javaType.remoteVendorManagementStatus(),
            serialNumber = javaType.serialNumber(),
            storageApplianceSkuId = javaType.storageApplianceSkuId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
