@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property adminUsername The name of the administrator to which the ssh public keys will be added into the authorized keys.
 * @property availabilityZone The cluster availability zone containing this virtual machine.
 * @property bareMetalMachineId The resource ID of the bare metal machine that hosts the virtual machine.
 * @property bootMethod Selects the boot method for the virtual machine.
 * @property cloudServicesNetworkAttachment The cloud service network that provides platform-level services for the virtual machine.
 * @property clusterId The resource ID of the cluster the virtual machine is created for.
 * @property cpuCores The number of CPU cores in the virtual machine.
 * @property detailedStatus The more detailed status of the virtual machine.
 * @property detailedStatusMessage The descriptive message about the current detailed status.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property isolateEmulatorThread Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine.
 * @property location The geo-location where the resource lives
 * @property memorySizeGB The memory size of the virtual machine in GB.
 * @property name The name of the resource
 * @property networkAttachments The list of network attachments to the virtual machine.
 * @property networkData The Base64 encoded cloud-init network data.
 * @property placementHints The scheduling hints for the virtual machine.
 * @property powerState The power state of the virtual machine.
 * @property provisioningState The provisioning state of the virtual machine.
 * @property sshPublicKeys The list of ssh public keys. Each key will be added to the virtual machine using the cloud-init ssh_authorized_keys mechanism for the adminUsername.
 * @property storageProfile The storage profile that specifies size and other parameters about the disks related to the virtual machine.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userData The Base64 encoded cloud-init user data.
 * @property virtioInterface Field Deprecated, use virtualizationModel instead. The type of the virtio interface.
 * @property vmDeviceModel The type of the device model to use.
 * @property vmImage The virtual machine image that is currently provisioned to the OS disk, using the full url and tag notation used to pull the image.
 * @property vmImageRepositoryCredentials The credentials used to login to the image repository that has access to the specified image.
 * @property volumes The resource IDs of volumes that are attached to the virtual machine.
 */
public data class GetVirtualMachineResult(
    public val adminUsername: String,
    public val availabilityZone: String,
    public val bareMetalMachineId: String,
    public val bootMethod: String? = null,
    public val cloudServicesNetworkAttachment: NetworkAttachmentResponse,
    public val clusterId: String,
    public val cpuCores: Double,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val isolateEmulatorThread: String? = null,
    public val location: String,
    public val memorySizeGB: Double,
    public val name: String,
    public val networkAttachments: List<NetworkAttachmentResponse>? = null,
    public val networkData: String? = null,
    public val placementHints: List<VirtualMachinePlacementHintResponse>? = null,
    public val powerState: String,
    public val provisioningState: String,
    public val sshPublicKeys: List<SshPublicKeyResponse>? = null,
    public val storageProfile: StorageProfileResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userData: String? = null,
    public val virtioInterface: String? = null,
    public val vmDeviceModel: String? = null,
    public val vmImage: String,
    public val vmImageRepositoryCredentials: ImageRepositoryCredentialsResponse? = null,
    public val volumes: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetVirtualMachineResult): GetVirtualMachineResult = GetVirtualMachineResult(
            adminUsername = javaType.adminUsername(),
            availabilityZone = javaType.availabilityZone(),
            bareMetalMachineId = javaType.bareMetalMachineId(),
            bootMethod = javaType.bootMethod().map({ args0 -> args0 }).orElse(null),
            cloudServicesNetworkAttachment = javaType.cloudServicesNetworkAttachment().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkAttachmentResponse.Companion.toKotlin(args0)
            }),
            clusterId = javaType.clusterId(),
            cpuCores = javaType.cpuCores(),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            isolateEmulatorThread = javaType.isolateEmulatorThread().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            memorySizeGB = javaType.memorySizeGB(),
            name = javaType.name(),
            networkAttachments = javaType.networkAttachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkAttachmentResponse.Companion.toKotlin(args0)
                })
            }),
            networkData = javaType.networkData().map({ args0 -> args0 }).orElse(null),
            placementHints = javaType.placementHints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.VirtualMachinePlacementHintResponse.Companion.toKotlin(args0)
                })
            }),
            powerState = javaType.powerState(),
            provisioningState = javaType.provisioningState(),
            sshPublicKeys = javaType.sshPublicKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin(args0)
                })
            }),
            storageProfile = javaType.storageProfile().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.StorageProfileResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userData = javaType.userData().map({ args0 -> args0 }).orElse(null),
            virtioInterface = javaType.virtioInterface().map({ args0 -> args0 }).orElse(null),
            vmDeviceModel = javaType.vmDeviceModel().map({ args0 -> args0 }).orElse(null),
            vmImage = javaType.vmImage(),
            vmImageRepositoryCredentials = javaType.vmImageRepositoryCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ImageRepositoryCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            volumes = javaType.volumes().map({ args0 -> args0 }),
        )
    }
}
