@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalHostInformation Freeform data extracted from the environment about this machine. This information varies depending on the specific hardware and configuration.
 * @property interfaces The list of network interfaces and associated details for the bare metal machine.
 * @property nics Field Deprecated. Will be removed in an upcoming version. The list of network interface cards and associated details for the bare metal machine.
 */
public data class HardwareInventoryResponse(
    public val additionalHostInformation: String,
    public val interfaces: List<HardwareInventoryNetworkInterfaceResponse>,
    public val nics: List<NicResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.HardwareInventoryResponse): HardwareInventoryResponse = HardwareInventoryResponse(
            additionalHostInformation = javaType.additionalHostInformation(),
            interfaces = javaType.interfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.HardwareInventoryNetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            nics = javaType.nics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.NicResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
