@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password The password or token used to access an image in the target repository.
 * @property registryUrl The URL of the authentication server used to validate the repository credentials.
 * @property username The username used to access an image in the target repository.
 */
public data class ImageRepositoryCredentialsResponse(
    public val password: String,
    public val registryUrl: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ImageRepositoryCredentialsResponse): ImageRepositoryCredentialsResponse = ImageRepositoryCredentialsResponse(
            password = javaType.password(),
            registryUrl = javaType.registryUrl(),
            username = javaType.username(),
        )
    }
}
