@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property azureUserName The user name that will be used for access.
 * @property status The indicator of whether the user is currently deployed for access.
 * @property statusMessage The additional information describing the current status of this user, if any available.
 */
public data class KeySetUserStatusResponse(
    public val azureUserName: String,
    public val status: String,
    public val statusMessage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.KeySetUserStatusResponse): KeySetUserStatusResponse = KeySetUserStatusResponse(
            azureUserName = javaType.azureUserName(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
        )
    }
}
