@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property portDescription The descriptive information about the port on the connected device.
 * @property portName The system-assigned name of the port on the connected device.
 * @property systemDescription The descriptive information about the connected device.
 * @property systemName The system-assigned name of the connected device.
 */
public data class LldpNeighborResponse(
    public val portDescription: String,
    public val portName: String,
    public val systemDescription: String,
    public val systemName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.LldpNeighborResponse): LldpNeighborResponse = LldpNeighborResponse(
            portDescription = javaType.portDescription(),
            portName = javaType.portName(),
            systemDescription = javaType.systemDescription(),
            systemName = javaType.systemName(),
        )
    }
}
