@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachedNetworkConfiguration The configuration of networks being attached to the cluster for use by the workloads that run on this Kubernetes cluster.
 * @property bgpServiceLoadBalancerConfiguration The configuration of the BGP service load balancer for this Kubernetes cluster.
 * @property cloudServicesNetworkId The resource ID of the associated Cloud Services network.
 * @property cniNetworkId The resource ID of the Layer 3 network that is used for creation of the Container Networking Interface network.
 * @property dnsServiceIp The IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in service CIDR.
 * @property podCidrs The CIDR notation IP ranges from which to assign pod IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 * @property serviceCidrs The CIDR notation IP ranges from which to assign service IPs. One IPv4 CIDR is expected for single-stack networking. Two CIDRs, one for each IP family (IPv4/IPv6), is expected for dual-stack networking.
 */
public data class NetworkConfigurationResponse(
    public val attachedNetworkConfiguration: AttachedNetworkConfigurationResponse? = null,
    public val bgpServiceLoadBalancerConfiguration: BgpServiceLoadBalancerConfigurationResponse? =
        null,
    public val cloudServicesNetworkId: String,
    public val cniNetworkId: String,
    public val dnsServiceIp: String? = null,
    public val podCidrs: List<String>? = null,
    public val serviceCidrs: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.NetworkConfigurationResponse): NetworkConfigurationResponse = NetworkConfigurationResponse(
            attachedNetworkConfiguration = javaType.attachedNetworkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.AttachedNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bgpServiceLoadBalancerConfiguration = javaType.bgpServiceLoadBalancerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.BgpServiceLoadBalancerConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cloudServicesNetworkId = javaType.cloudServicesNetworkId(),
            cniNetworkId = javaType.cniNetworkId(),
            dnsServiceIp = javaType.dnsServiceIp().map({ args0 -> args0 }).orElse(null),
            podCidrs = javaType.podCidrs().map({ args0 -> args0 }),
            serviceCidrs = javaType.serviceCidrs().map({ args0 -> args0 }),
        )
    }
}
