@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property definitionsLastUpdated The timestamp when the malware definitions were last updated.
 * @property definitionsVersion The version of the malware definitions.
 * @property scanCompletedTime The timestamp of the most recently completed scan, or empty if there has never been a scan.
 * @property scanScheduledTime The timestamp of the most recently scheduled scan, or empty if no scan has been scheduled.
 * @property scanStartedTime The timestamp of the most recently started scan, or empty if there has never been a scan.
 */
public data class RuntimeProtectionStatusResponse(
    public val definitionsLastUpdated: String,
    public val definitionsVersion: String,
    public val scanCompletedTime: String,
    public val scanScheduledTime: String,
    public val scanStartedTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.RuntimeProtectionStatusResponse): RuntimeProtectionStatusResponse = RuntimeProtectionStatusResponse(
            definitionsLastUpdated = javaType.definitionsLastUpdated(),
            definitionsVersion = javaType.definitionsVersion(),
            scanCompletedTime = javaType.scanCompletedTime(),
            scanScheduledTime = javaType.scanScheduledTime(),
            scanStartedTime = javaType.scanStartedTime(),
        )
    }
}
