@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property grouping Selection of how the type evaluation is applied to the cluster calculation.
 * @property type Selection of how the threshold should be evaluated.
 * @property value The numeric threshold value.
 */
public data class ValidationThresholdResponse(
    public val grouping: String,
    public val type: String,
    public val `value`: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ValidationThresholdResponse): ValidationThresholdResponse = ValidationThresholdResponse(
            grouping = javaType.grouping(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
