@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin

import com.pulumi.azurenative.networkfunction.AzureTrafficCollectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Traffic Collector resource.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2022-05-01.
 * Other available API versions: 2022-08-01.
 * ## Example Usage
 * ### Create a traffic collector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureTrafficCollector = new AzureNative.NetworkFunction.AzureTrafficCollector("azureTrafficCollector", new()
 *     {
 *         AzureTrafficCollectorName = "atc",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkfunction/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfunction.NewAzureTrafficCollector(ctx, "azureTrafficCollector", &networkfunction.AzureTrafficCollectorArgs{
 * 			AzureTrafficCollectorName: pulumi.String("atc"),
 * 			Location:                  pulumi.String("West US"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkfunction.AzureTrafficCollector;
 * import com.pulumi.azurenative.networkfunction.AzureTrafficCollectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureTrafficCollector = new AzureTrafficCollector("azureTrafficCollector", AzureTrafficCollectorArgs.builder()
 *             .azureTrafficCollectorName("atc")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkfunction:AzureTrafficCollector atc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}
 * ```
 * @property azureTrafficCollectorName Azure Traffic Collector name
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class AzureTrafficCollectorArgs(
    public val azureTrafficCollectorName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkfunction.AzureTrafficCollectorArgs> {
    override fun toJava(): com.pulumi.azurenative.networkfunction.AzureTrafficCollectorArgs =
        com.pulumi.azurenative.networkfunction.AzureTrafficCollectorArgs.builder()
            .azureTrafficCollectorName(azureTrafficCollectorName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureTrafficCollectorArgs].
 */
@PulumiTagMarker
public class AzureTrafficCollectorArgsBuilder internal constructor() {
    private var azureTrafficCollectorName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("afmievhmdahxxewe")
    public suspend fun azureTrafficCollectorName(`value`: Output<String>) {
        this.azureTrafficCollectorName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dttybbmnlcpghclw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dfpcetotbaxplgnl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("olucgidbfvodnqnb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("spjtqvvtmmitsnos")
    public suspend fun azureTrafficCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTrafficCollectorName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vwhgmjnpppfvlppn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hnxcykvytbdsocye")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("inudpycmfatwjphk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lqvwexbgrhkgjnku")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureTrafficCollectorArgs = AzureTrafficCollectorArgs(
        azureTrafficCollectorName = azureTrafficCollectorName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
