@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Ingestion Policy properties.
 * @property ingestionSources Ingestion Sources.
 * @property ingestionType The ingestion type.
 */
public data class IngestionPolicyPropertiesFormatResponse(
    public val ingestionSources: List<IngestionSourcesPropertiesFormatResponse>? = null,
    public val ingestionType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkfunction.outputs.IngestionPolicyPropertiesFormatResponse): IngestionPolicyPropertiesFormatResponse = IngestionPolicyPropertiesFormatResponse(
            ingestionSources = javaType.ingestionSources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkfunction.kotlin.outputs.IngestionSourcesPropertiesFormatResponse.Companion.toKotlin(args0)
                })
            }),
            ingestionType = javaType.ingestionType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
