@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Ingestion policy properties.
 * @property resourceId Resource ID.
 * @property sourceType Ingestion source type.
 */
public data class IngestionSourcesPropertiesFormatResponse(
    public val resourceId: String? = null,
    public val sourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkfunction.outputs.IngestionSourcesPropertiesFormatResponse): IngestionSourcesPropertiesFormatResponse = IngestionSourcesPropertiesFormatResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            sourceType = javaType.sourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
