@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRuleArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.SharedAccessAuthorizationRulePropertiesArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.SharedAccessAuthorizationRulePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Response for POST requests that return single SharedAccessAuthorizationRule.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
 * ## Example Usage
 * ### Namespaces_CreateOrUpdateAuthorizationRule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceAuthorizationRule = new AzureNative.NotificationHubs.NamespaceAuthorizationRule("namespaceAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "sdk-AuthRules-1788",
 *         NamespaceName = "nh-sdk-ns",
 *         Properties = new AzureNative.NotificationHubs.Inputs.SharedAccessAuthorizationRulePropertiesArgs
 *         {
 *             Rights = new[]
 *             {
 *                 AzureNative.NotificationHubs.AccessRights.Listen,
 *                 AzureNative.NotificationHubs.AccessRights.Send,
 *             },
 *         },
 *         ResourceGroupName = "5ktrial",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := notificationhubs.NewNamespaceAuthorizationRule(ctx, "namespaceAuthorizationRule", &notificationhubs.NamespaceAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("sdk-AuthRules-1788"),
 * 			NamespaceName:         pulumi.String("nh-sdk-ns"),
 * 			Properties: &notificationhubs.SharedAccessAuthorizationRulePropertiesArgs{
 * 				Rights: pulumi.StringArray{
 * 					pulumi.String(notificationhubs.AccessRightsListen),
 * 					pulumi.String(notificationhubs.AccessRightsSend),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("5ktrial"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRule;
 * import com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRuleArgs;
 * import com.pulumi.azurenative.notificationhubs.inputs.SharedAccessAuthorizationRulePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceAuthorizationRule = new NamespaceAuthorizationRule("namespaceAuthorizationRule", NamespaceAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("sdk-AuthRules-1788")
 *             .namespaceName("nh-sdk-ns")
 *             .properties(SharedAccessAuthorizationRulePropertiesArgs.builder()
 *                 .rights(
 *                     "Listen",
 *                     "Send")
 *                 .build())
 *             .resourceGroupName("5ktrial")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:NamespaceAuthorizationRule NewAuthorizationRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/authorizationRules/{authorizationRuleName}
 * ```
 * @property authorizationRuleName Authorization Rule Name
 * @property location Deprecated - only for compatibility.
 * @property namespaceName Namespace name
 * @property properties SharedAccessAuthorizationRule properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Deprecated - only for compatibility.
 */
public data class NamespaceAuthorizationRuleArgs(
    public val authorizationRuleName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val properties: Output<SharedAccessAuthorizationRulePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRuleArgs =
        com.pulumi.azurenative.notificationhubs.NamespaceAuthorizationRuleArgs.builder()
            .authorizationRuleName(authorizationRuleName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NamespaceAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class NamespaceAuthorizationRuleArgsBuilder internal constructor() {
    private var authorizationRuleName: Output<String>? = null

    private var location: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var properties: Output<SharedAccessAuthorizationRulePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Authorization Rule Name
     */
    @JvmName("qssshtdpcpggnrpv")
    public suspend fun authorizationRuleName(`value`: Output<String>) {
        this.authorizationRuleName = value
    }

    /**
     * @param value Deprecated - only for compatibility.
     */
    @JvmName("afhsctltftxwwaht")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Namespace name
     */
    @JvmName("lukgtmtiqbyfvlbm")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value SharedAccessAuthorizationRule properties.
     */
    @JvmName("fqufuivjcxaosmqy")
    public suspend fun properties(`value`: Output<SharedAccessAuthorizationRulePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("niyfoniftaqoiijw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Deprecated - only for compatibility.
     */
    @JvmName("uuhbuisywbphnjlb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Authorization Rule Name
     */
    @JvmName("ardhvrmnuxrgjuwm")
    public suspend fun authorizationRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value Deprecated - only for compatibility.
     */
    @JvmName("wrfchhicugiqnxet")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Namespace name
     */
    @JvmName("iufudflcfkmuslix")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value SharedAccessAuthorizationRule properties.
     */
    @JvmName("xeoelsrxdtdnfhqq")
    public suspend fun properties(`value`: SharedAccessAuthorizationRulePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument SharedAccessAuthorizationRule properties.
     */
    @JvmName("rpgkomlayhyjanlv")
    public suspend fun properties(argument: suspend SharedAccessAuthorizationRulePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SharedAccessAuthorizationRulePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dmdhydpblyrsndgd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Deprecated - only for compatibility.
     */
    @JvmName("nwpfordicjlljomb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Deprecated - only for compatibility.
     */
    @JvmName("jcjimkqlcwrbykxq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NamespaceAuthorizationRuleArgs = NamespaceAuthorizationRuleArgs(
        authorizationRuleName = authorizationRuleName,
        location = location,
        namespaceName = namespaceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
