@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.GetNamespacePnsCredentialsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName Namespace name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNamespacePnsCredentialsPlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.GetNamespacePnsCredentialsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.GetNamespacePnsCredentialsPlainArgs =
        com.pulumi.azurenative.notificationhubs.inputs.GetNamespacePnsCredentialsPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespacePnsCredentialsPlainArgs].
 */
@PulumiTagMarker
public class GetNamespacePnsCredentialsPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Namespace name
     */
    @JvmName("ejaqbrcitlxkgugq")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("exnjhxvwbuaaxbyu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNamespacePnsCredentialsPlainArgs = GetNamespacePnsCredentialsPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
