@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub MpnsCredential.
 * @property certificateKey Gets or sets the certificate key for this credential.
 * @property mpnsCertificate Gets or sets the MPNS certificate.
 * @property thumbprint Gets or sets the MPNS certificate Thumbprint
 */
public data class MpnsCredentialPropertiesArgs(
    public val certificateKey: Output<String>,
    public val mpnsCertificate: Output<String>,
    public val thumbprint: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialPropertiesArgs = com.pulumi.azurenative.notificationhubs.inputs.MpnsCredentialPropertiesArgs.builder()
        .certificateKey(certificateKey.applyValue({ args0 -> args0 }))
        .mpnsCertificate(mpnsCertificate.applyValue({ args0 -> args0 }))
        .thumbprint(thumbprint.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MpnsCredentialPropertiesArgs].
 */
@PulumiTagMarker
public class MpnsCredentialPropertiesArgsBuilder internal constructor() {
    private var certificateKey: Output<String>? = null

    private var mpnsCertificate: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value Gets or sets the certificate key for this credential.
     */
    @JvmName("unafpoanfybfrpkq")
    public suspend fun certificateKey(`value`: Output<String>) {
        this.certificateKey = value
    }

    /**
     * @param value Gets or sets the MPNS certificate.
     */
    @JvmName("nqoranudokdyoiyc")
    public suspend fun mpnsCertificate(`value`: Output<String>) {
        this.mpnsCertificate = value
    }

    /**
     * @param value Gets or sets the MPNS certificate Thumbprint
     */
    @JvmName("lifmmmqawgngvtjo")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Gets or sets the certificate key for this credential.
     */
    @JvmName("iishahgtlogbgbdk")
    public suspend fun certificateKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateKey = mapped
    }

    /**
     * @param value Gets or sets the MPNS certificate.
     */
    @JvmName("fvoqfaeqdscubrmi")
    public suspend fun mpnsCertificate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mpnsCertificate = mapped
    }

    /**
     * @param value Gets or sets the MPNS certificate Thumbprint
     */
    @JvmName("tnbgqehysngxjuxf")
    public suspend fun thumbprint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): MpnsCredentialPropertiesArgs = MpnsCredentialPropertiesArgs(
        certificateKey = certificateKey ?: throw PulumiNullFieldException("certificateKey"),
        mpnsCertificate = mpnsCertificate ?: throw PulumiNullFieldException("mpnsCertificate"),
        thumbprint = thumbprint ?: throw PulumiNullFieldException("thumbprint"),
    )
}
