@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.RemotePrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.enums.PrivateLinkConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * State of the Private Link Service connection.
 * @property status State of Private Link Connection.
 */
public data class RemotePrivateLinkServiceConnectionStateArgs(
    public val status: Output<Either<String, PrivateLinkConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.RemotePrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.RemotePrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.notificationhubs.inputs.RemotePrivateLinkServiceConnectionStateArgs.builder()
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RemotePrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class RemotePrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var status: Output<Either<String, PrivateLinkConnectionStatus>>? = null

    /**
     * @param value State of Private Link Connection.
     */
    @JvmName("tyimvlrxefppdbuv")
    public suspend fun status(`value`: Output<Either<String, PrivateLinkConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value State of Private Link Connection.
     */
    @JvmName("benqghkvcypmamfq")
    public suspend fun status(`value`: Either<String, PrivateLinkConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value State of Private Link Connection.
     */
    @JvmName("wlqejapirefblnui")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateLinkConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value State of Private Link Connection.
     */
    @JvmName("ujgkxhexgcsualvn")
    public fun status(`value`: PrivateLinkConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateLinkConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): RemotePrivateLinkServiceConnectionStateArgs =
        RemotePrivateLinkServiceConnectionStateArgs(
            status = status,
        )
}
