@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub AdmCredential.
 * @property authTokenUrl Gets or sets the URL of the authorization token.
 * @property clientId Gets or sets the client identifier.
 * @property clientSecret Gets or sets the credential secret access key.
 */
public data class AdmCredentialPropertiesResponse(
    public val authTokenUrl: String,
    public val clientId: String,
    public val clientSecret: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.AdmCredentialPropertiesResponse): AdmCredentialPropertiesResponse = AdmCredentialPropertiesResponse(
            authTokenUrl = javaType.authTokenUrl(),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
        )
    }
}
