@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub ApnsCredential.
 * @property apnsCertificate Gets or sets the APNS certificate.
 * @property appId Gets or sets the issuer (iss) registered claim key, whose value is
 * your 10-character Team ID, obtained from your developer account
 * @property appName Gets or sets the name of the application
 * @property certificateKey Gets or sets the certificate key.
 * @property endpoint Gets or sets the endpoint of this credential.
 * @property keyId Gets or sets a 10-character key identifier (kid) key, obtained from
 * your developer account
 * @property thumbprint Gets or sets the APNS certificate Thumbprint
 * @property token Gets or sets provider Authentication Token, obtained through your
 * developer account
 */
public data class ApnsCredentialPropertiesResponse(
    public val apnsCertificate: String? = null,
    public val appId: String? = null,
    public val appName: String? = null,
    public val certificateKey: String? = null,
    public val endpoint: String,
    public val keyId: String? = null,
    public val thumbprint: String? = null,
    public val token: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.ApnsCredentialPropertiesResponse): ApnsCredentialPropertiesResponse = ApnsCredentialPropertiesResponse(
            apnsCertificate = javaType.apnsCertificate().map({ args0 -> args0 }).orElse(null),
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            appName = javaType.appName().map({ args0 -> args0 }).orElse(null),
            certificateKey = javaType.certificateKey().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint(),
            keyId = javaType.keyId().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
            token = javaType.token().map({ args0 -> args0 }).orElse(null),
        )
    }
}
