@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub BaiduCredential.
 * @property baiduApiKey Gets or sets baidu Api Key.
 * @property baiduEndPoint Gets or sets baidu Endpoint.
 * @property baiduSecretKey Gets or sets baidu Secret Key
 */
public data class BaiduCredentialPropertiesResponse(
    public val baiduApiKey: String,
    public val baiduEndPoint: String,
    public val baiduSecretKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.BaiduCredentialPropertiesResponse): BaiduCredentialPropertiesResponse = BaiduCredentialPropertiesResponse(
            baiduApiKey = javaType.baiduApiKey(),
            baiduEndPoint = javaType.baiduEndPoint(),
            baiduSecretKey = javaType.baiduSecretKey(),
        )
    }
}
